/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatCoE_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat CoE
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      4         23.03.2007  sb
        updated source header
        corrected task entry function

**************************************************************************************/
#ifndef __ECAT_COE_FUNCTIONLIST_H
#define __ECAT_COE_FUNCTIONLIST_H



/***************************************************************************************/
/* Ecat CoE function list, prototyes */

TLR_RESULT  TaskExit_EcatCoE (void* pvRsc);

TLR_RESULT  TaskLeave_EcatCoE(void* pvRsc,
                              void* pvLve);

void        TaskEnter_EcatCoE(void* pvInit);


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_COE_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_COE_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_COE_STARTUPPARAMETER_Ttag  ECAT_COE_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_COE_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
};

/** @} */

/***************************************************************************************/
#endif /* #ifndef __ECAT_COE_FUNCTIONLIST_H */
